﻿using System.Net;
using gov.va.med.VBECS.Communication.Common;
using gov.va.med.VBECS.Communication.Protocols;

namespace gov.va.med.VBECS.Communication.Clients
{
    /// <summary>
    /// Provides client object
    /// </summary>
    public static class ClientFactory
    {
        /// <summary>
        /// Creates client
        /// </summary>
        /// <param name="theServerEndPoint">IPEndPoint</param>
        /// <returns>a client</returns>
        public static IClient CreateClient<T>(IPEndPoint theServerEndPoint) where T : IPinger, new()
        {
            return new TcpClient<T>(theServerEndPoint);
        }

        /// <summary>
        /// Creates client
        /// </summary>
        /// <param name="theServerEndPoint">IPEndPoint</param>
        /// <param name="protocol">Communication protocol</param>
        /// <returns>a client</returns>
        public static IClient CreateClient<T>(IPEndPoint theServerEndPoint, IProtocol protocol) where T : IPinger, new()
        {
            return new TcpClient<T>(theServerEndPoint, protocol);
        }

        /// <summary>
        /// Used mostly for testing
        /// </summary>
        /// <returns>a client</returns>
        public static IClient CreateEchoClient<T>() where T : IPinger, new()
        {
            return new EchoClient<T>();
        }
    }
}
